<?php
include 'koneksi.php';

// Periksa apakah parameter ID telah diterima
if (isset($_GET['id'])) {
    $id_transaksi = $_GET['id'];

    // Perintah SQL untuk mengambil data transaksi berdasarkan ID
    $sql = "SELECT * FROM transaksi WHERE id = $id_transaksi";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
    } else {
        echo "Transaksi tidak ditemukan.";
    }
} else {
    echo "Parameter ID tidak ditemukan.";
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    @page {
      size: 58mm 100mm;
      margin: 10;
    }

	body {
	  font-family: Arial, sans-serif;
	  font-size: 16px;
	  margin: 20px;
	  padding: 0px;
	  max-width: 100%; /* Menggunakan 100% agar menyesuaikan lebar perangkat */
	}


    .invoice-header {
      text-align: center;
      font-weight: bold;
      font-size: 14px;
      margin-bottom: 5px;
    }

    .logo {
      text-align: center;
      margin-bottom: 0px;
    }

    .logo img {
      max-width: 20%;
      height: auto;
    }

    .invoice-details {
      margin: 0px;
      margin-bottom: 0;
    }

    .item-row {
      padding: 0px 0;
      overflow: hidden;
    }

    .item-row .item-name {
      float: left;
      width: 100%;
    }

    .item-row .item-qty {
      float: left;
    }

    .item-row .item-price {
      float: right;
      width: 40%;
      text-align: right;
      margin-bottom: 5px;
    }

    .total-row {
      padding-top: 0px;
    }

    .invoice-details p {
      margin: 0;
    }

    .total-row {
      padding-top: 5px;
      display: flex;
      justify-content: space-between;
      border-top: 1px dashed #000;
    }

    #total-price-label {
      float: left;
    }

    #total-price {
      float: right;
      text-align: right;
    }

    .payment-details {
      display: flex;
      flex-direction: row;
      align-items: center;
    }

    .garisputus {
      margin-top: 5px;
      margin-bottom: 5px;
      border-top: 1px dashed #000;
    }

    @media print {
      /* Hide the Print button in print view */
      button {
        display: none;
      }
    }
  </style>
  <script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>
</head>
<body>
  <div class="logo">
    <img src="../gambar/japri.png" alt="Logo">
  </div>
  <div class="container mt-5">
    <div class="invoice-header">
      Jariyah Printing
    </div><br>
    <div id="transaction-details">
      <p class="invoice-details">Kode Transaksi : <span id="transaction-id"><?php echo $row['idtransaksi']; ?></span></p>
      <p class="invoice-details"><span id="transaction-time"><?php echo str_replace(array("Tanggal: ", "Jam: "), "", $row['transactionTime']); ?></span></p>
      <p class="invoice-details">Admin :&nbsp;<span id="admin-name"><?php echo $row['adminName']; ?></span></p>
      <p class="invoice-details">Pelanggan :&nbsp;<span id="customer-name"><?php echo $row['customerName']; ?></span></p>
      <div class="garisputus"></div>
      <div id="cart-items">
<div id="cart-items">
    <?php
    if (isset($_GET['id'])) {
        $id = $_GET['id'];

        include '../koneksi.php';

        // Perintah SQL untuk mengambil data transaksi berdasarkan ID
        $sql = "SELECT * FROM transaksi WHERE id = $id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $cartItems = json_decode($row['cartItems'], true);

            foreach ($cartItems as $item) {
                echo '<div class="item-row">';
                echo '<div class="item-name">' . $item['produk'] . '</div>';
                echo '<div class="item-qty">@' . number_format($item['harga'], 0, ',', '.') . '</div>';
                echo '<div class="item-qty">&nbsp;x ' . $item['quantity'] . '</div>';
                echo '<div class="item-price">Rp ' . number_format($item['subtotal'], 0, ',', '.') . '</div>';
                echo '</div>';
            }
        } else {
            echo "Transaksi tidak ditemukan.";
        }

        // Tutup koneksi ke basis data
        $conn->close();
    }
    ?>
</div>

      </div>
      <div class="total-row">
        <strong><span id="total-price-label">Total Harga:</span></strong>
        <strong><span id="total-price">Rp <?php echo number_format($row['totalPrice'], 0, ',', '.')?></span></strong>
      </div>
      <div class="payment-details">
        <p class="invoice-details">Ket Bayar :&nbsp;</p>
        <p class="invoice-details"><span id="payment-status"><?php echo $row['paymentStatus']; ?></span></p>
      </div>
	  <p class="invoice-details">Status : <span id="payment-status"><?php echo $row['statusOrderan']; ?></span></p>
      <div class="payment-details">
		<?php
		if ($row['dpAmount'] != 0) {
			echo '<p class="invoice-details">DP: <span id="dp-amount">Rp' . number_format($row['dpAmount'], 0, ',', '.') . '</span></p>';
		}
		?>
      <div style="width: 100%; text-align: center; margin-top: 20px;">
    Terimakasih telah mencetak di Jariyah Printing.<br>
    Jl. Antang Raya Ruko ABC No. 8<br>
    <br>Catatan: <br>Cetakan yang tidak diambil lewat dari 30 hari diluar tanggung jawab kami.
  </div>
      </div>
    </div>
  </div>
      <script>

function saveInvoiceAsImage() {
    // Sembunyikan tombol "Print" dan "Simpan sebagai Gambar"
    const printButton = document.querySelector('button:nth-of-type(1)');
    const saveButton = document.querySelector('button:nth-of-type(2)');
    printButton.style.display = 'none';
    saveButton.style.display = 'none';

    const invoiceContainer = document.querySelector('.invoice-header').parentElement;
    const scale = 2;

    html2canvas(invoiceContainer, { scale: scale }).then(canvas => {
        const image = canvas.toDataURL('image/png');

        const a = document.createElement('a');
        a.href = image;
        a.download = 'invoice.png';
        a.click();

        // Tampilkan kembali tombol "Print" dan "Simpan sebagai Gambar"
        printButton.style.display = 'inline-block';
        saveButton.style.display = 'inline-block';
    });
}


        
        function printInvoice() {
            // Open the print dialog
            window.print();
        }
</script>
</body>
</html>

